; sse_string6.asm
; znajdowanie podłańcucha
extern print16b
extern printf
section .data					        
	string1	db	"szybki czerwony dinozaur skacze przez "
			db	"leniwy strumyk, a leniwy dinozaur "
			db	"sobie drzemie",10,0 
	string2	db  "dinozaur",0
	NL  	db 	10,0
	fmt 	db 	"Znajdowanie podłańcucha '%s' w łańcuchu:",10,0
	fmt_oc 	db 	"Znalazłem %ld %sy(-ów)",10,0

section .bss
section .text
	global main					
main:
push	rbp
mov	rbp,rsp

; najpierw wypisujemy łańcuch
    mov rdi, fmt
    mov rsi, string2
    xor rax,rax
    call printf
    mov rdi, string1
    xor rax,rax
    call printf 
; przeszukujemy łańcuch
    mov rdi, string1
    mov rsi, string2
    call psubstringsrch
; wypisujemy liczbę wystąpień podłańcucha
	mov rdi, fmt_oc
	mov rsi, rax
	mov rdx, string2
	call printf
leave
ret

;-------------------------------------------------------------
; funkcja do wyszukiwania podłańcucha i wypisywania maski

psubstringsrch:         ; wyszukiwanie podłańcucha
push	rbp		
mov	rbp,rsp
    	sub  rsp,16      ; miejsce na odłożenie xmm1
    	xor 	r12,r12     ; bieżąca suma wystąpień
    	xor 	rcx,rcx     ; do sygnalizowania końca
    	xor 	rbx,rbx     ; do obliczania adresów
    	mov 	rax,-16     ; unikamy ustawienia flagi ZF
; budujemy xmm1, wczytujemy podłańcuch
    pxor 		xmm1,xmm1
    movdqu 	xmm1,[rsi] 
.loop:
    add 		rax,16	; unikamy ustawienia flagi ZF
    mov 		rsi,16 	; jeśli nie ma końcowego zera, wypisujemy 16 bajtów
    movdqu 	xmm2,[rdi+rbx]
    pcmpistrm 	xmm1,xmm2,01001100b ; 'równy uporządkowany'|'maska bajtowa w xmm0'
    setz  	cl   	; wykryto końcowe zero

; jeśli znaleziono końcowe zero, ustalamy pozycję
	cmp 	cl,0
	je 	.gotoprint  	; nie znaleziono końcowego zera
	; znaleziono końcowe zero
	; zostało mniej niż 16 bajtów
	; rdi zawiera adres łańcucha
	; rbx zawiera liczbę bajtów w dotychczas przetworzonych blokach
	add 	rdi,rbx		; bierzemy tylko końcówkę łańcucha
	push	rcx			; zapisywany przez wywołującego (cl w użyciu)
	call pstrlen       	; w rax zwracana jest pozycja zera
	push	rcx			; zapisywany przez wywołującego (cl w użyciu)
	dec 	rax         ; długość bez zera
	mov 	rsi,rax		; długość pozostałych bajtów

; wypisywanie maski
.gotoprint:
	call print_mask 
; obliczamy bieżącą sumę dopasowań
    	popcnt	r13d,r13d	; zliczamy bity o wartości 1
    	add 	r12d,r13d	; zachowujemy liczbę wystąpień w r12d
    	or  	cl,cl 	 	; wykryto końcowe zero?
    	jnz 	.exit    
    	add 	rbx,16 		; przygotowujemy się na następny blok
    	jmp 	.loop
.exit:
    	mov	rdi, NL
    	call printf
    	mov 	rax, r12 ; zwracamy liczbę wystąpień
leave
ret
;-------------------------------------------------------------
pstrlen:
push	rbp		
mov	rbp,rsp
    	sub     	rsp,16    	; miejsce na zapisanie xmm0
		movdqu 	[rbp-16],xmm0	; odkładamy xmm0 na stos
    	mov       rax, -16		; unikamy późniejszego ustawienia flagi ZF
    	pxor      xmm0, xmm0	; szukamy zera (końca łańcucha)	
.loop:	
    	add   	rax, 16     	; unikamy ustawienia flagi ZF, kiedy rax = 0 po pcmpistri
    	pcmpistri	xmm0, [rdi + rax], 0x08 ;'równy każdy'
    	jnz    	.loop    	  	; znaleziono zero?
    	add       rax, rcx		; rax = już przetworzone bajty
								; rcx = bajty przetworzone w ostatniej pętli
    	movdqu 	xmm0,[rbp-16] 	; zdejmujemy xmm0 ze stosu
leave
ret
;-------------------------------------------------------------
; funkcja do wypisywania maski
; xmm0 zawiera maskę
; rsi zawiera liczbę bitów do wypisania (16 lub mniej)
print_mask:
push	rbp		
mov	rbp,rsp
		sub 		rsp,16 		; miejsce na zapisanie xmm0
    	call 	reverse_xmm0	; little endian
    	pmovmskb 	r13d,xmm0  	; przenosimy maskę bajtową do edx
    	movdqu 	[rbp-16],xmm1	; odkładamy xmm1 na stos ze względu na printf
    	push 	rdi        		; rdi zawiera string1
    	mov 		edi,r13d	; zawiera maskę do wypisania
    	push 		rdx			; zawiera maskę
    	push 		rcx        	; zawiera flagę końca łańcucha
    	call 		print16b
    	pop 		rcx
    	pop 		rdx
    	pop 		rdi
    	movdqu 	xmm1,[rbp-16]	; zdejmujemy xmm1 ze stosu
leave
ret
;-------------------------------------------------------------
; funkcja do odwracania (tasowania) xmm0
reverse_xmm0:
section .data
;mask for reversing
        .bytereverse db 15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0
section .text
push	rbp		
mov 	rbp,rsp
    	sub     rsp,16
    	movdqu [rbp-16],xmm2	 
    	movdqu xmm2,[.bytereverse] 	; wczytujemy maskę do xmm2
    	pshufb xmm0,xmm2           	; tasujemy
    	movdqu xmm2,[rbp-16]	   	; zdejmujemy xmm2 ze stosu
leave                               ; zwracamy przetasowany rejestr xmm0
ret
